package gov.va.med.mhv.common.api.dto;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class UserProfileDTO implements Serializable {

	private static final long serialVersionUID = 122388229562277991L;

	private Long id;

	private NameDTO name = new NameDTO();
	private Date birthDate;
	private String bloodType;

	private Date deathDate;
	private String ssn;
	private String confSsn;
	private String occupation;
	private String gender;
	private String maritalStatus;
	private String mhvId;
	private Boolean interestAlcohol;
	private Boolean interestBloodPressure;
	private Boolean interestDepression;
	private Boolean interestDiabetes;
	private Boolean interestDiet;
	private Boolean interestExercise;
	private Boolean interestHeart;
	private Boolean interestMilitaryRelated;
	private Boolean interestPTSD;
	private Boolean interestReminder;
	private Boolean interestSmoking;
	private Boolean interestStress;
	private Boolean isAdministrator;
	private Boolean isMPIControlled;
	private Boolean organDonor;

	//patient Type
	private Boolean isPatient;
	private Boolean isPatientAdvocate;
	private Boolean isVeteran;
	private Boolean isChampVABeneficiary;
	private Boolean isServiceMemeber;
	private Boolean isEmployee;
	private Boolean isHealthCareProvider;
	private Boolean isOther;

	private Boolean acceptDisclaimer;

	private Boolean acceptPrivacy;
	private Boolean acceptSMTerms;
	private Boolean acceptTerms;
	private Boolean autoAuth;
	private Date autoAuthDate;
	private Boolean confirmationLockOut;
	private Date createdDate;
	private Date currentLogin;
	private UserProfileDeactivationReasonDTO deactivationReason;
	private Boolean ehrAccess;
	private Boolean emailCredentials;
	private Boolean emailHealthAwareness;
	private Boolean orientationVideoView;
	private Boolean participationFormSign;
	private Boolean physicalProof;
	private Integer proofInstitutionId;
	private String proofLevel;
	private Date proofLevelDate;
	private Date rxAgreementDate;
	private Boolean rxAgreementSigned;
	private Set<EmergencyContactDTO> emergencyContacts;
	private AddressDTO address = new AddressDTO();
	private AddressDTO alternateAddress = new AddressDTO();
	private ContactDTO contact = new ContactDTO();
	// private String addressCity;
	// private String contactInfoPager;
	// private String contactInfoWorkPhone;
	private String userAlias;
	// private SuffixEnumeration suffix;
	private String currentOccupation;
	private String alternateAddressCountry;
	// private TitleEnumeration title;

	private String userName;
	private String password;
	private String confPassword;
	private String oldPassword;

	// private String answer1;
	// private String answer2;
	// private Integer question1;
	// private Integer question2;

	private Date passwordLastChanged;
	private Boolean passwordLockOut;
	private Boolean temporaryPassword;
	private Date lastLogin;
	private List<String> accessRoles;
	private Integer oplock;
	private Integer lockCount;
	private Date lockDate;
	//TODO: Remove - Prasad
	//private String[] tellus;

	// Added Attributes
	 private String firstName;
	 private String lastName;

	private Integer passwordHintQuestion1;
	private Integer passwordHintQuestion2;
	private String passwordHintAnswer1;
	private String passwordHintAnswer2;
	// private String addressProvince;
	private String addressState;
	// private CountryEnumeration addressCountry;
	// private ContactMethodEnumeration contactInfoContactMethod;
	private String alternateAddressPostalCode;
	// private String addressPostalCode;
	// private String contactInfoEmail;
	private String middleName;
	// private String addressStreet1;
	// private String addressStreet2;
	private String alternateAddressProvince;
	// private String contactInfoHomePhone;
	// private String contactInfoMobilePhone;
	private String alternateAddressCity;
	private String alternateAddressStreet1;
	private Boolean isOrganDonor;
	private String alternateAddressState;
	private String alternateAddressStreet2;
	// private String contactInfoFax;
	private Date modifiedDate;
	private Date fccx;
	private Boolean rxTrackingEmailPref;
	private Boolean apptReminderEmailPref;
	private Boolean healthSummarySentEmailPref;
	private Boolean bbmiEmailPref;
	private String confEmail;

	//required for registration result
	private String infoMessage;
	private String accountType;
	private String impreciseBirthDate;

	private String	signInPartners;

	private Boolean restrictSIPAccess;
	private String restrictSIPAccessBy;
	private Date restrictSIPAccessDate;
	private String restrictSIPAccessReason;


	private Timestamp termsModifiedTime;

	private Date accountDeactivationWarning;
		private Integer deactivationCode;
		private String deactivationDescriptionText;
		private Date deactivationDateTime;
	private String deactivationAdmin;

	private Boolean isAlternate;
	
	public UserProfileDTO() {
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public NameDTO getName() {
		return name;
	}

	public void setName(NameDTO name) {
		this.name = name;
	}

	public Date getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public String getBloodType() {
		return bloodType;
	}

	public void setBloodType(String bloodType) {
		this.bloodType = bloodType;
	}

	public Date getDeathDate() {
		return deathDate;
	}

	public void setDeathDate(Date deathDate) {
		this.deathDate = deathDate;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getConfSsn() {
		return confSsn;
	}

	public void setConfSsn(String confSsn) {
		this.confSsn = confSsn;
	}

	public String getOccupation() {
		return occupation;
	}

	public void setOccupation(String occupation) {
		this.occupation = occupation;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getMaritalStatus() {
		return maritalStatus;
	}

	public void setMaritalStatus(String maritalStatus) {
		this.maritalStatus = maritalStatus;
	}

	public String getMhvId() {
		return mhvId;
	}

	public void setMhvId(String mhvId) {
		this.mhvId = mhvId;
	}

	public Boolean getInterestAlcohol() {
		return interestAlcohol;
	}

	public void setInterestAlcohol(Boolean interestAlcohol) {
		this.interestAlcohol = interestAlcohol;
	}

	public Boolean getInterestBloodPressure() {
		return interestBloodPressure;
	}

	public void setInterestBloodPressure(Boolean interestBloodPressure) {
		this.interestBloodPressure = interestBloodPressure;
	}

	public Boolean getInterestDepression() {
		return interestDepression;
	}

	public void setInterestDepression(Boolean interestDepression) {
		this.interestDepression = interestDepression;
	}

	public Boolean getInterestDiabetes() {
		return interestDiabetes;
	}

	public void setInterestDiabetes(Boolean interestDiabetes) {
		this.interestDiabetes = interestDiabetes;
	}

	public Boolean getInterestDiet() {
		return interestDiet;
	}

	public void setInterestDiet(Boolean interestDiet) {
		this.interestDiet = interestDiet;
	}

	public Boolean getInterestExercise() {
		return interestExercise;
	}

	public void setInterestExercise(Boolean interestExercise) {
		this.interestExercise = interestExercise;
	}

	public Boolean getInterestHeart() {
		return interestHeart;
	}

	public void setInterestHeart(Boolean interestHeart) {
		this.interestHeart = interestHeart;
	}

	public Boolean getInterestMilitaryRelated() {
		return interestMilitaryRelated;
	}

	public void setInterestMilitaryRelated(Boolean interestMilitaryRelated) {
		this.interestMilitaryRelated = interestMilitaryRelated;
	}

	public Boolean getInterestPTSD() {
		return interestPTSD;
	}

	public void setInterestPTSD(Boolean interestPTSD) {
		this.interestPTSD = interestPTSD;
	}

	public Boolean getInterestReminder() {
		return interestReminder;
	}

	public void setInterestReminder(Boolean interestReminder) {
		this.interestReminder = interestReminder;
	}

	public Boolean getInterestSmoking() {
		return interestSmoking;
	}

	public void setInterestSmoking(Boolean interestSmoking) {
		this.interestSmoking = interestSmoking;
	}

	public Boolean getInterestStress() {
		return interestStress;
	}

	public void setInterestStress(Boolean interestStress) {
		this.interestStress = interestStress;
	}

	public Boolean getIsAdministrator() {
		return isAdministrator;
	}

	public void setIsAdministrator(Boolean isAdministrator) {
		this.isAdministrator = isAdministrator;
	}

	public Boolean getIsMPIControlled() {
		return isMPIControlled;
	}

	public void setIsMPIControlled(Boolean isMPIControlled) {
		this.isMPIControlled = isMPIControlled;
	}

	public Boolean getIsEmployee() {
		return isEmployee;
	}

	public void setIsEmployee(Boolean isEmployee) {
		this.isEmployee = isEmployee;
	}

	public Boolean getIsHealthCareProvider() {
		return isHealthCareProvider;
	}

	public void setIsHealthCareProvider(Boolean isHealthCareProvider) {
		this.isHealthCareProvider = isHealthCareProvider;
	}

	public Boolean getOrganDonor() {
		return organDonor;
	}

	public void setOrganDonor(Boolean organDonor) {
		this.organDonor = organDonor;
	}

	public Boolean getIsOther() {
		return isOther;
	}

	public void setIsOther(Boolean isOther) {
		this.isOther = isOther;
	}

	public Boolean getIsPatient() {
		return isPatient;
	}

	public void setIsPatient(Boolean isPatient) {
		this.isPatient = isPatient;
	}

	public Boolean getIsPatientAdvocate() {
		return isPatientAdvocate;
	}

	public void setIsPatientAdvocate(Boolean isPatientAdvocate) {
		this.isPatientAdvocate = isPatientAdvocate;
	}

	public Boolean getIsVeteran() {
		return isVeteran;
	}

	public void setIsVeteran(Boolean isVeteran) {
		this.isVeteran = isVeteran;
	}

	public Boolean getIsChampVABeneficiary() {
		return this.isChampVABeneficiary;
	}

	public void setIsChampVABeneficiary(Boolean isChampVABeneficiary) {
		this.isChampVABeneficiary = isChampVABeneficiary;
	}

	public Boolean getIsServiceMember() {
		return this.isServiceMemeber;
	}

	public void setIsServiceMember(Boolean isServiceMemeber) {
		this.isServiceMemeber = isServiceMemeber;
	}

	public Boolean getAcceptDisclaimer() {
		return acceptDisclaimer;
	}

	public void setAcceptDisclaimer(Boolean acceptDisclaimer) {
		this.acceptDisclaimer = acceptDisclaimer;
	}

	public Boolean getAcceptPrivacy() {
		return acceptPrivacy;
	}

	public void setAcceptPrivacy(Boolean acceptPrivacy) {
		this.acceptPrivacy = acceptPrivacy;
	}

	public Boolean getAcceptSMTerms() {
		return acceptSMTerms;
	}

	public void setAcceptSMTerms(Boolean acceptSMTerms) {
		this.acceptSMTerms = acceptSMTerms;
	}

	public Boolean getAcceptTerms() {
		return acceptTerms;
	}

	public void setAcceptTerms(Boolean acceptTerms) {
		this.acceptTerms = acceptTerms;
	}

	public Boolean getAutoAuth() {
		return autoAuth;
	}

	public void setAutoAuth(Boolean autoAuth) {
		this.autoAuth = autoAuth;
	}

	public Date getAutoAuthDate() {
		return autoAuthDate;
	}

	public void setAutoAuthDate(Date autoAuthDate) {
		this.autoAuthDate = autoAuthDate;
	}

	public Boolean getConfirmationLockOut() {
		return confirmationLockOut;
	}

	public void setConfirmationLockOut(Boolean confirmationLockOut) {
		this.confirmationLockOut = confirmationLockOut;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getCurrentLogin() {
		return currentLogin;
	}

	public void setCurrentLogin(Date currentLogin) {
		this.currentLogin = currentLogin;
	}

	public Boolean getEhrAccess() {
		return ehrAccess;
	}

	public void setEhrAccess(Boolean ehrAccess) {
		this.ehrAccess = ehrAccess;
	}

	public Boolean getEmailCredentials() {
		return emailCredentials;
	}

	public void setEmailCredentials(Boolean emailCredentials) {
		this.emailCredentials = emailCredentials;
	}

	public Boolean getEmailHealthAwareness() {
		return emailHealthAwareness;
	}

	public void setEmailHealthAwareness(Boolean emailHealthAwareness) {
		this.emailHealthAwareness = emailHealthAwareness;
	}

	public Boolean getOrientationVideoView() {
		return orientationVideoView;
	}

	public void setOrientationVideoView(Boolean orientationVideoView) {
		this.orientationVideoView = orientationVideoView;
	}

	public Boolean getParticipationFormSign() {
		return participationFormSign;
	}

	public void setParticipationFormSign(Boolean participationFormSign) {
		this.participationFormSign = participationFormSign;
	}

	public Boolean getPhysicalProof() {
		return physicalProof;
	}

	public void setPhysicalProof(Boolean physicalProof) {
		this.physicalProof = physicalProof;
	}

	public Integer getProofInstitutionId() {
		return proofInstitutionId;
	}

	public void setProofInstitutionId(Integer proofInstitutionId) {
		this.proofInstitutionId = proofInstitutionId;
	}

	public String getProofLevel() {
		return proofLevel;
	}

	public void setProofLevel(String proofLevel) {
		this.proofLevel = proofLevel;
	}

	public Date getProofLevelDate() {
		return proofLevelDate;
	}

	public void setProofLevelDate(Date proofLevelDate) {
		this.proofLevelDate = proofLevelDate;
	}

	public Date getRxAgreementDate() {
		return rxAgreementDate;
	}

	public void setRxAgreementDate(Date rxAgreementDate) {
		this.rxAgreementDate = rxAgreementDate;
	}

	public Boolean getRxAgreementSigned() {
		return rxAgreementSigned;
	}

	public void setRxAgreementSigned(Boolean rxAgreementSigned) {
		this.rxAgreementSigned = rxAgreementSigned;
	}

	public Set<EmergencyContactDTO> getEmergencyContacts() {
		return emergencyContacts;
	}

	public void setEmergencyContacts(Set<EmergencyContactDTO> emergencyContacts) {
		this.emergencyContacts = emergencyContacts;
	}

	public AddressDTO getAddress() {
		return address;
	}

	public void setAddress(AddressDTO address) {
		this.address = address;
	}

	public AddressDTO getAlternateAddress() {
		return alternateAddress;
	}

	public void setAlternateAddress(AddressDTO alternateAddress) {
		this.alternateAddress = alternateAddress;
	}

	public ContactDTO getContact() {
		return contact;
	}

	public void setContact(ContactDTO contact) {
		this.contact = contact;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getConfPassword() {
		return confPassword;
	}

	public void setConfPassword(String confPassword) {
		this.confPassword = confPassword;
	}

	public String getSignInPartners() {
		return signInPartners;
	}

	public void setSignInPartners(String signInPartners) {
		this.signInPartners = signInPartners;
	}

	public Boolean getRestrictSIPAccess() {
		return restrictSIPAccess;
	}

	public void setRestrictSIPAccess(Boolean restrictSIPAccess) {
		this.restrictSIPAccess = restrictSIPAccess;
	}

	public String getRestrictSIPAccessBy() {
		return restrictSIPAccessBy;
	}

	public void setRestrictSIPAccessBy(String restrictSIPAccessBy) {
		this.restrictSIPAccessBy = restrictSIPAccessBy;
	}

	public Date getRestrictSIPAccessDate() {
		return restrictSIPAccessDate;
	}

	public void setRestrictSIPAccessDate(Date restrictSIPAccessDate) {
		this.restrictSIPAccessDate = restrictSIPAccessDate;
	}

	public String getRestrictSIPAccessReason() {
		return restrictSIPAccessReason;
	}

	public void setRestrictSIPAccessReason(String restrictSIPAccessReason) {
		this.restrictSIPAccessReason = restrictSIPAccessReason;
	}

public Date getAccountDeactivationWarning() {
		return accountDeactivationWarning;
	}

	public void setAccountDeactivationWarning(Date accountDeactivationWarning) {
		this.accountDeactivationWarning = accountDeactivationWarning;
	}

	public Integer getDeactivationCode() {
		return deactivationCode;
	}

	public void setDeactivationCode(Integer deactivationCode) {
		this.deactivationCode = deactivationCode;
	}

	public String getDeactivationDescriptionText() {
		return deactivationDescriptionText;
	}

	public void setDeactivationDescriptionText(String deactivationDescriptionText) {
		this.deactivationDescriptionText = deactivationDescriptionText;
	}

	public Date getDeactivationDateTime() {
		return deactivationDateTime;
	}

	public void setDeactivationDateTime(Date deactivationDateTime) {
		this.deactivationDateTime = deactivationDateTime;
	}

	public String getDeactivationAdmin() {
		return deactivationAdmin;
	}

	public void setDeactivationAdmin(String deactivationAdmin) {
		this.deactivationAdmin = deactivationAdmin;
	}

	/*
	public String getAnswer1() {
		return answer1;
	}

	public void setAnswer1(String answer1) {
		this.answer1 = answer1;
	}

	public String getAnswer2() {
		return answer2;
	}

	public Integer getQuestion1() {
		return question1;
	}

	public void setQuestion1(Integer question1) {
		this.question1 = question1;
	}

	public Integer getQuestion2() {
		return question2;
	}

	public void setQuestion2(Integer question2) {
		this.question2 = question2;
	}

	public void setAnswer2(String answer2) {
		this.answer2 = answer2;
	}*/

	public Date getPasswordLastChanged() {
		return passwordLastChanged;
	}

	public void setPasswordLastChanged(Date passwordLastChanged) {
		this.passwordLastChanged = passwordLastChanged;
	}

	public Boolean getPasswordLockOut() {
		return passwordLockOut;
	}

	public void setPasswordLockOut(Boolean passwordLockOut) {
		this.passwordLockOut = passwordLockOut;
	}

	public Boolean getTemporaryPassword() {
		return temporaryPassword;
	}

	public void setTemporaryPassword(Boolean temporaryPassword) {
		this.temporaryPassword = temporaryPassword;
	}

	public Date getLastLogin() {
		return lastLogin;
	}

	public void setLastLogin(Date lastLogin) {
		this.lastLogin = lastLogin;
	}

	public List<String> getAccessRoles() {
		return accessRoles;
	}

	public void setAccessRoles(List<String> accessRoles) {
		this.accessRoles = accessRoles;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Integer getLockCount() {
		return lockCount;
	}

	public void setLockCount(Integer lockCount) {
		this.lockCount = lockCount;
	}

	public Date getLockDate() {
		return lockDate;
	}

	public void setLockDate(Date lockDate) {
		this.lockDate = lockDate;
	}

	public Integer getPasswordHintQuestion1() {
		return passwordHintQuestion1;
	}

	public void setPasswordHintQuestion1(Integer passwordHintQuestion1) {
		this.passwordHintQuestion1 = passwordHintQuestion1;
	}

	public Integer getPasswordHintQuestion2() {
		return passwordHintQuestion2;
	}

	public void setPasswordHintQuestion2(Integer passwordHintQuestion2) {
		this.passwordHintQuestion2 = passwordHintQuestion2;
	}

	public String getAddressState() {
		return addressState;
	}

	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}

	public String getAlternateAddressPostalCode() {
		return alternateAddressPostalCode;
	}

	public void setAlternateAddressPostalCode(String alternateAddressPostalCode) {
		this.alternateAddressPostalCode = alternateAddressPostalCode;
	}

	public String getAlternateAddressProvince() {
		return alternateAddressProvince;
	}

	public void setAlternateAddressProvince(String alternateAddressProvince) {
		this.alternateAddressProvince = alternateAddressProvince;
	}

	public String getPasswordHintAnswer1() {
		return passwordHintAnswer1;
	}

	public void setPasswordHintAnswer1(String passwordHintAnswer1) {
		this.passwordHintAnswer1 = passwordHintAnswer1;
	}

	public String getAlternateAddressCity() {
		return alternateAddressCity;
	}

	public void setAlternateAddressCity(String alternateAddressCity) {
		this.alternateAddressCity = alternateAddressCity;
	}

	public String getUserAlias() {
		return userAlias;
	}

	public void setUserAlias(String userAlias) {
		this.userAlias = userAlias;
	}

	public String getAlternateAddressStreet1() {
		return alternateAddressStreet1;
	}

	public void setAlternateAddressStreet1(String alternateAddressStreet1) {
		this.alternateAddressStreet1 = alternateAddressStreet1;
	}

	public Boolean getIsOrganDonor() {
		return isOrganDonor;
	}

	public void setIsOrganDonor(Boolean isOrganDonor) {
		this.isOrganDonor = isOrganDonor;
	}

	public String getAlternateAddressState() {
		return alternateAddressState;
	}

	public void setAlternateAddressState(String alternateAddressState) {
		this.alternateAddressState = alternateAddressState;
	}

	public String getPasswordHintAnswer2() {
		return passwordHintAnswer2;
	}

	public void setPasswordHintAnswer2(String passwordHintAnswer2) {
		this.passwordHintAnswer2 = passwordHintAnswer2;
	}

	public String getCurrentOccupation() {
		return currentOccupation;
	}

	public void setCurrentOccupation(String currentOccupation) {
		this.currentOccupation = currentOccupation;
	}

	public String getAlternateAddressStreet2() {
		return alternateAddressStreet2;
	}

	public void setAlternateAddressStreet2(String alternateAddressStreet2) {
		this.alternateAddressStreet2 = alternateAddressStreet2;
	}

	public String getAlternateAddressCountry() {
		return alternateAddressCountry;
	}

	public void setAlternateAddressCountry(String alternateAddressCountry) {
		this.alternateAddressCountry = alternateAddressCountry;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Date getFccx() {
		return fccx;
	}

	public void setFccx(Date fccx) {
		this.fccx = fccx;
	}

	public Boolean getRxTrackingEmailPref() {
		if (null == rxTrackingEmailPref) {
			this.rxTrackingEmailPref = false;
		}
		return rxTrackingEmailPref;
	}

	public void setRxTrackingEmailPref(Boolean rxTrackingEmailPref) {
		this.rxTrackingEmailPref = rxTrackingEmailPref;
	}

	public Boolean getApptReminderEmailPref() {
		if(null == apptReminderEmailPref)
			this.apptReminderEmailPref = false;
		return apptReminderEmailPref;
	}

	public void setApptReminderEmailPref(Boolean apptReminderEmailPref) {
		this.apptReminderEmailPref = apptReminderEmailPref;
	}

	public Boolean getBbmiEmailPref() {
		if(null == bbmiEmailPref)
			this.bbmiEmailPref = false;
		return bbmiEmailPref;
	}

	public void setBbmiEmailPref(Boolean bbmiEmailPref) {
		this.bbmiEmailPref = bbmiEmailPref;
	}

	public Boolean getHealthSummarySentEmailPref() {
		if(null == this.healthSummarySentEmailPref)
			this.healthSummarySentEmailPref = false;
		return this.healthSummarySentEmailPref;
	}

	public void setHealthSummarySentEmailPref(Boolean healthSummarySentEmailPref) {
		this.healthSummarySentEmailPref = healthSummarySentEmailPref;
	}

	public String getConfEmail() {
		return confEmail;
	}

	public void setConfEmail(String confEmail) {
		this.confEmail = confEmail;
	}

	public void setInfoMessage(String infoMessage) {
		this.infoMessage = infoMessage;
	}

	public String getInfoMessage() {
		return infoMessage;
	}

	public void setAccountType(String accountType) {
		this.accountType = accountType;
	}

	public String getAccountType() {
		return accountType;
	}

	public void setTermsModifiedTime(Timestamp termsModifiedTime) {
		this.termsModifiedTime = termsModifiedTime;
	}

	public Timestamp getTermsModifiedTime() {
		return termsModifiedTime;
	}

	public String getOldPassword() {
		return oldPassword;
	}

	public void setOldPassword(String oldPassword) {
		this.oldPassword = oldPassword;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getImpreciseBirthDate() {
		return impreciseBirthDate;
	}

	public void setImpreciseBirthDate(String impreciseBirthDate) {
		this.impreciseBirthDate = impreciseBirthDate;
	}

	public UserProfileDeactivationReasonDTO getDeactivationReason() {
		return deactivationReason;
	}

	public void setDeactivationReason(
			UserProfileDeactivationReasonDTO deactivationReason) {
		this.deactivationReason = deactivationReason;
	}

	public Boolean getIsAlternate() {
		return isAlternate;
	}

	public void setIsAlternate(Boolean isAlternate) {
		this.isAlternate = isAlternate;
	}
}